class ClassificationOfWork {
    constructor() {
        this.demandLevelSelector = null;
        this.containerId = 'classification-of-work-container';
    }

    render() {
        return `
            <div id="${this.containerId}" class="classification-of-work-section">
                <div id="demand-level-selector-container"></div>
            </div>
        `;
    }

    init() {

        if (typeof DemandLevelSelector === 'undefined') {
            setTimeout(() => this.init(), 100);
            return;
        }

        this.demandLevelSelector = new DemandLevelSelector({
            containerId: 'demand-level-selector-container',
            required: true,
            onChange: (selectedLevel) => {
            }
        });
    }

    getData() {
        return {
            physicalLevel: this.demandLevelSelector ? this.demandLevelSelector.getSelectedLevel() : null
        };
    }

    setData(data) {
        if (!data || !this.demandLevelSelector) return;

        if (data.physicalLevel) {
            this.demandLevelSelector.setSelectedLevel(data.physicalLevel);
        }
    }

    validate() {
        if (!this.demandLevelSelector) return false;
        return this.demandLevelSelector.validate();
    }
}

if (typeof module !== 'undefined' && module.exports) {
    module.exports = ClassificationOfWork;
}