class CognitiveSensoryDemands {
    constructor() {
        this.table = null;
        this.containerId = 'cognitive-sensory-demands-table-container';
    }

    render() {
        return `
            <div class="demands-section cognitive-sensory-demands">
                <div id="${this.containerId}"></div>
            </div>
        `;
    }

    init() {

        const container = document.getElementById(this.containerId);
        if (!container) {
            console.warn(`Cognitive and sensory demands container ${this.containerId} not found, will retry...`);
            return;
        }

const rowGroups = [
    {
        category: 'Vision',
        rows: [0, 1, 2, 3, 4, 5]
    },
    {
        category: 'Hearing',
        rows: [6, 7, 8]
    },
    {
        category: 'Senses',
        rows: [9, 10, 11, 12, 13]
    },
    {
        category: 'Cognitive',
        rows: [14, 15, 16, 17, 18, 19]
    },
    {
        category: 'Psychosocial',
        rows: [20, 21, 22]
    }
];

const headerRows = [

    'Near Vision',
    'Far Vision',
    'Peripheral Vision',
    'Depth Perception',
    'Color Vision',
    'Perceive Safety/Emergency Indicators',

    'Distinguish Sounds or Tones',
    'Verbal or Electronic Communication',
    'Perceive Safety/Emergency Indicators',

    'Tactile Sense (Touch)',
    'Olfactory Sense (Smell)',
    'Gustatory Sense (Taste)',
    'Vestibular Sense (Balance)',
    'Kinesthetic Sense (Proprioception)',

    'Memory (Short or Long Term)',
    'Multitasking',
    'Decision Making and Reasoning',
    'Simple Math',
    'Time Management',
    'Literacy (Reading/Writing)',

    'Work Independently',
    'Work with a Team',
    'Supervision of Others',
];

        this.table = new Table({
            containerId: this.containerId,
            headerColumns: [
                { lines: ['Required'] },
                { lines: ['Objective Measurements & General Comments'] }
            ],
            headerRows: headerRows,
            rowGroups: rowGroups,
            cellType: 'selectable',
            columnTypes: ['selectable', 'input'],
            rowHeaderWidth: '250px',
            columnWidths: ['100px', 'auto'],
            selectionMode: 'multiple',
            striped: true,
            hoverable: true,
            showValidationErrors: false,
            onChange: (data) => {

            }
        });
    }

    getData() {
        if (!this.table) {
            console.warn('Cognitive and sensory demands table not initialized yet, returning empty data');
            return {};
        }
        return this.table.getData();
    }

    setData(data) {
        if (!data) return;

        if (!this.table) {
            console.warn('Cognitive and sensory demands table not initialized yet, attempting to initialize...');
            this.init();
        }

        if (this.table) {
            this.table.setData(data);
        } else {
            console.error('Failed to initialize cognitive and sensory demands table for setData');
        }
    }

    clear() {
        if (this.table) {
            this.table.clear();
        }
    }

    validate() {
        return true;
    }
}

if (typeof module !== 'undefined' && module.exports) {
    module.exports = CognitiveSensoryDemands;
}