class LiftingPushingPulling {
    constructor() {
        this.table = null;
        this.containerId = 'lifting-pushing-pulling-table-container';
    }

    render() {
        return `
            <div class="demands-section lifting-pushing-pulling-demands">
                <div id="${this.containerId}"></div>
            </div>
        `;
    }

    init() {

        const container = document.getElementById(this.containerId);
        if (!container) {
            console.warn(`Lifting, pushing, and pulling demands container ${this.containerId} not found, will retry...`);
            return;
        }

        const headerRows = [
            'Less than 5 lbs',
            '5-25 lbs',
            '26-50 lbs',
            '51-100 lbs',
            'Over 100 lbs'
        ];

        this.table = new Table({
            containerId: this.containerId,
            headerColumns: [
                { responsive: { full: 'N/A\nor None', short: 'N/A', letter: 'N' } },
                { responsive: { full: 'Occasional\n1-33%\n<12 reps/hour', short: 'Occasional', letter: 'O' } },
                { responsive: { full: 'Frequent\n34-66%\n12-60 reps/hour', short: 'Frequent', letter: 'F' } },
                { responsive: { full: 'Constant\n67-100%\n>60 reps/hour', short: 'Constant', letter: 'C' } },
                { responsive: { full: 'Objective Measurements\n& General Comments', short: 'Comments', letter: 'Notes' } }
            ],
            headerRows: headerRows,
            cellType: 'selectable',
            selectionMode: 'single',
            rowHeaderWidth: 'auto',
            columnWidths: ['auto', 'auto', 'auto', 'auto', 'auto'],
            columnTypes: ['selectable', 'selectable', 'selectable', 'selectable', 'input'],
            striped: true,
            hoverable: true,
            showValidationErrors: true,
            onChange: (data) => {

            }
        });
    }

    getData() {
        if (!this.table) {
            console.warn('Lifting, pushing, and pulling demands table not initialized yet, returning empty data');
            return {};
        }
        return this.table.getData();
    }

    setData(data) {
        if (!data) return;

        if (!this.table) {
            console.warn('Lifting, pushing, and pulling demands table not initialized yet, attempting to initialize...');
            this.init();
        }

        if (this.table) {
            this.table.setData(data);
        } else {
            console.error('Failed to initialize lifting, pushing, and pulling demands table for setData');
        }
    }

    clear() {
        if (this.table) {
            this.table.clear();
        }
    }

    validate() {
        if (!this.table) {
            return false;
        }
        return this.table.validate();
    }

    getValidationErrors() {
        if (!this.table) {
            return {};
        }
        return this.table.getValidationErrors();
    }

    clearValidationErrors() {
        if (this.table) {
            this.table.clearValidationErrors();
        }
    }
}

if (typeof module !== 'undefined' && module.exports) {
    module.exports = LiftingPushingPulling;
}