class MobilityDemands {
    constructor() {
        this.table = null;
        this.containerId = 'mobility-demands-table-container';
    }

    render() {
        return `
            <div class="demands-section mobility-demands">
                <div id="${this.containerId}"></div>
            </div>
        `;
    }

    init() {

        const container = document.getElementById(this.containerId);
        if (!container) {
            console.warn(`Mobility demands container ${this.containerId} not found, will retry...`);
            return;
        }

        const rowGroups = [
            {
                category: 'Neck',
                rows: [0, 1, 2]
            },
            {
                category: 'Shoulder',
                rows: [3, 4, 5, 6]
            },
            {
                category: 'Elbow and Forearm',
                rows: [7, 8]
            },
            {
                category: 'Wrist and Fingers',
                rows: [9, 10, 11]
            },
            {
                category: 'Thorax and Upper Back',
                rows: [12, 13, 14]
            },
            {
                category: 'Lower Back and Abdomen',
                rows: [15, 16, 17]
            },
            {
                category: 'Hip and Upper Thigh',
                rows: [18, 19, 20]
            },
            {
                category: 'Knees and Lower Legs',
                rows: [21]
            },
            {
                category: 'Ankle, Foot, and Toes',
                rows: [22]
            }
        ];

        const headerRows = [
            'Flexion/Extension',
            'Rotation',
            'Lateral Flexion/Extension',
            'Flexion/Extension',
            'Abduction/Adduction',
            'Internal/External Rotation',
            'Elevation/Depression',
            'Flexion/Extension',
            'Supination/Pronation',
            'Flexion/Extension',
            'Ulnar/Radial Deviation',
            'Gripping (Power or Pinch)',
            'Flexion/Extension',
            'Rotation',
            'Lateral Flexion/Extension',
            'Flexion/Extension',
            'Rotation',
            'Lateral Flexion/Extension',
            'Flexion/Extension',
            'Abduction/Adduction',
            'Internal/External Rotation',
            'Flexion/Extension',
            'Dorsiflexion/Plantarflexion'
        ];

        this.table = new Table({
            containerId: this.containerId,
            headerColumns: [
                { responsive: { full: 'Not Applicable\n0%', short: 'N/A', letter: 'N' } },
                { responsive: { full: 'Occasional\n1-33%', short: 'Occasional', letter: 'O' } },
                { responsive: { full: 'Frequent\n34-66%', short: 'Frequent', letter: 'F' } },
                { responsive: { full: 'Constant\n67-100%', short: 'Constant', letter: 'C' } },
                { responsive: { full: 'Objective Measurements\n& General Comments', short: 'Comments', letter: 'Notes' } }
            ],
            headerRows: headerRows,
            rowGroups: rowGroups,
            cellType: 'selectable',
            selectionMode: 'single',
            rowHeaderWidth: '200px',
            columnTypes: ['selectable', 'selectable', 'selectable', 'selectable', 'input'],
            columnWidths: ['auto', 'auto', 'auto', 'auto', 'auto'],
            striped: true,
            hoverable: true,
            showValidationErrors: true,
            onChange: (data) => {

            }
        });
    }

    getData() {
        if (!this.table) {
            console.warn('Mobility demands table not initialized yet, returning empty data');
            return {};
        }
        return this.table.getData();
    }

    setData(data) {
        if (!data) return;

        if (!this.table) {
            console.warn('Mobility demands table not initialized yet, attempting to initialize...');
            this.init();
        }

        if (this.table) {
            this.table.setData(data);
        } else {
            console.error('Failed to initialize mobility demands table for setData');
        }
    }

    clear() {
        if (this.table) {
            this.table.clear();
        }
    }

    validate() {
        if (!this.table) {
            return false;
        }
        return this.table.validate();
    }

    getValidationErrors() {
        if (!this.table) {
            return {};
        }
        return this.table.getValidationErrors();
    }

    clearValidationErrors() {
        if (this.table) {
            this.table.clearValidationErrors();
        }
    }
}

if (typeof module !== 'undefined' && module.exports) {
    module.exports = MobilityDemands;
}