class PhysicalDemands {
    constructor() {
        this.table = null;
        this.containerId = 'physical-demands-table-container';
    }

    render() {
        return `
            <div class="demands-section physical-demands">
                <div id="${this.containerId}"></div>
            </div>
        `;
    }

    init() {

        const container = document.getElementById(this.containerId);
        if (!container) {
            console.warn(`Physical demands container ${this.containerId} not found, will retry...`);
            return;
        }

        this.table = new Table({
            containerId: this.containerId,
            headerColumns: [
                { responsive: { full: 'Not Applicable\n0%', short: 'N/A', letter: 'N' } },
                { responsive: { full: 'Occasional\n1-33%', short: 'Occasional', letter: 'O' } },
                { responsive: { full: 'Frequent\n34-66%', short: 'Frequent', letter: 'F' } },
                { responsive: { full: 'Constant\n67-100%', short: 'Constant', letter: 'C' } },
                { responsive: { full: 'Objective Measurements\n& General Comments', short: 'Comments', letter: 'Notes' } }
            ],
            headerRows: [
                'Awkward position',
                'Bending over',
                'Carrying',
                'Driving',
                'Fine motor tasks',
                'Gripping or grasping',
                'Handling',
                'Kneeling',
                'Lifting',
                'Lifting overhead',
                'Pulling',
                'Pushing',
                'Reaching',
                'Sitting',
                'Squatting or crouching',
                'Standing',
                'Talking and hearing',
                'Twisting or turning',
                'Walking'
            ],
            cellType: 'selectable',
            selectionMode: 'single',
            rowHeaderWidth: '200px',
            columnWidths: ['auto', 'auto', 'auto', 'auto', 'auto'],
            columnTypes: ['selectable', 'selectable', 'selectable', 'selectable', 'input'],
            striped: true,
            hoverable: true,
            showValidationErrors: true
        });
    }

    getData() {
        if (!this.table) {
            console.warn('Physical demands table not initialized yet, returning empty data');
            return {};
        }
        return this.table.getData();
    }

    setData(data) {
        if (!data) return;

        if (!this.table) {
            console.warn('Physical demands table not initialized yet, attempting to initialize...');
            this.init();
        }

        if (this.table) {
            this.table.setData(data);
        } else {
            console.error('Failed to initialize physical demands table for setData');
        }
    }

    validate() {
        if (!this.table) {
            return false;
        }

        return this.table.validate();
    }

    getValidationErrors() {
        if (!this.table) {
            return {};
        }
        return this.table.getValidationErrors();
    }

    clearValidationErrors() {
        if (this.table) {
            this.table.clearValidationErrors();
        }
    }
}

if (typeof module !== 'undefined' && module.exports) {
    module.exports = PhysicalDemands;
}